/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: libc_file_support.c $
   Last Modification:
    $Author: stephans $
    $Modtime: 5.02.07 12:31 $
    $Revision: 5192 $
   
   Targets:
     netX10/50/100/500   : yes
 
   Description:
   libc_file_support.c  Operating system specific functions for libc file support (fopen, ...)
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        13.12.2011  SS       initial version
 
**************************************************************************************/

/*****************************************************************************/
/*! \file libc_file_support.c                                                    
*   Operating system specific functions for libc file support (fopen, ...)   */
/*****************************************************************************/

#include <sys/types.h>
#include <sys/reent.h>
#include <sys/unistd.h>
#include <sys/stat.h>
#include <string.h> /* memset, etc */
#include <stdint.h>

#include "libc_file_support.h"
extern void HAL_UartInit( unsigned int uUartNr, uint32_t ulBaud);
extern void HAL_UartPutChar( unsigned int uUartNr, const uint8_t bChar );

/*****************************************************************************/
/*! Initialize the libc file support                                         */
/*****************************************************************************/
void libc_file_init()
{
  struct _reent* ptImpureData = (struct _reent*)_global_impure_ptr;
  
  HAL_UartInit(0, 1152);
     
  _REENT_INIT_PTR(ptImpureData);
}
 
/*****************************************************************************/
/*! Opens a file (non-reentrant)
*   \param szFile     Name and path of the file to open 
*   \param iFlags     Flags for file open (see O_RDONLY, O_WRONLY, O_RDWR, ...
*   \param iMode      Sharing mode (see S_IRWXU, ...)
*   \return -1 on error (errno holds last error)                             */
/*****************************************************************************/
int open(const char* szFile, int iFlags, int iMode)
{
  return -1;
}
  
/*****************************************************************************/
/*! Opens a file (reentrant)
*   \param ptReent    Reentrancy structure 
*   \param szFile     Name and path of the file to open 
*   \param iFlags     Flags for file open (see O_RDONLY, O_WRONLY, O_RDWR, ...
*   \param iMode      Sharing mode (see S_IRWXU, ...)
*   \return -1 on error (errno holds last error)                             */
/*****************************************************************************/
int _open_r(struct _reent* ptReent, const char* szFile, int iFlags, int iMode)
{
  return -1;
}

/*****************************************************************************/
/*! Closes a file (non-reentrant)
*   \param iFile  File Handle 
*   \return -1 on error (errno holds last error)                             */
/*****************************************************************************/
int close(int iFile)
{
  return -1;
}
  
/*****************************************************************************/
/*! Closes a file (non-reentrant)
*   \param ptReent  Reentrancy structure
*   \param iFile    File Handle 
*   \return -1 on error (errno holds last error)                             */
/*****************************************************************************/
int _close_r(struct _reent* ptReent, int iFile)
{
  return -1;
}

/*****************************************************************************/
/*! Queries state of a an open file (non-reentrant)
*   \param iFile    File Handle 
*   \param ptState  Returned state
*   \return -1 on error (errno holds last error)                             */
/*****************************************************************************/
int fstat(int iFile, struct stat* ptState)
{
  return -1;
}

/*****************************************************************************/
/*! Queries state of a an open file (reentrant)
*   \param ptReent  Reentrancy structure
*   \param iFile    File Handle 
*   \param ptState  Returned state
*   \return -1 on error (errno holds last error)                             */
/*****************************************************************************/
int _fstat_r(struct _reent* ptReent, int iFile, struct stat* ptState)
{
  return -1;
}

/*****************************************************************************/
/*! Queries state of a file (non-reentrant)
*   \param szName   Name of the file to get status for 
*   \param ptState  Returned state
*   \return -1 on error (errno holds last error)                             */
/*****************************************************************************/
int stat(const char* szName, struct stat* ptState)
{
  return -1;
}

/*****************************************************************************/
/*! Queries state of a file (reentrant)
*   \param ptReent  Reentrancy structure
*   \param szName   Name of the file to get status for 
*   \param ptState  Returned state
*   \return -1 on error (errno holds last error)                             */
/*****************************************************************************/
int _stat_r(struct _reent* ptReent, const char* szName, struct stat* ptState)
{
  return -1;
}


/*****************************************************************************/
/*! Queries if the file is a terminal (stdout)
*   \param iFile    File Handle 
*   \return !=0 if device is a terminal/tty device                           */
/*****************************************************************************/
int _isatty(int iFile)
{
  int iRet;

  switch(iFile)
  {  
  case STDERR_FILENO:
  case STDOUT_FILENO:
    iRet = 1;
    break;
    
  default:
    iRet = 0;
    break;
  }

  return iRet;
}

/*****************************************************************************/
/*! Establish a new name for an exisiting file (non-reentrant)
*   \param szOldName  Old file name/path 
*   \param szNewName  New file name/path
*   \return -1 on error (errno holds error)                                  */
/*****************************************************************************/
int link(const char* szOldName, const char* szNewName)
{
  return -1;
}

/*****************************************************************************/
/*! Establish a new name for an exisiting file (reentrant)
*   \param ptReent    Reentrancy structure 
*   \param szOldName  Old file name/path 
*   \param szNewName  New file name/path
*   \return -1 on error (errno holds error)                                  */
/*****************************************************************************/
int _link_r(struct _reent* ptReent, const char* szOldName, const char* szNewName)
{
  return -1;
}

/*****************************************************************************/
/*! Removes a file's directory entry (non-reentrant)
*   \param szName   Name of the file to delete 
*   \return -1 on error (errno holds error)                                  */
/*****************************************************************************/
int unlink(const char* szName)
{
  return -1;
}

/*****************************************************************************/
/*! Removes a file's directory entry (reentrant)
*   \param ptReent    Reentrancy structure 
*   \param szName   Name of the file to delete 
*   \return -1 on error (errno holds error)                                  */
/*****************************************************************************/
int _unlink_r(struct _reent* ptReent, const char* szName)
{
  return -1;
}

/*****************************************************************************/
/*! Reads from a file (non-reentrant)
*   \param iFile      File handle 
*   \param pvBuffer   Data to write to file
*   \param iBytes     number of bytes to write
*   \return number of bytes successfully read (-1 on error)                  */
/*****************************************************************************/
_ssize_t read(int iFile, void* pvBuffer, size_t iBytes)
{ 
  return 0;  
}

/*****************************************************************************/
/*! Reads from a file (non-reentrant)
*   \param ptReent    Reentrancy structure 
*   \param iFile      File handle 
*   \param pvBuffer   Data to write to file
*   \param iBytes     number of bytes to write
*   \return number of bytes successfully read (-1 on error)                  */
/*****************************************************************************/
_ssize_t _read_r(struct _reent* ptReent, int iFile, void* pvBuffer, size_t iBytes)
{
  size_t iRet;
  // TODO: Lock Access
  iRet = read(iFile, pvBuffer, iBytes);
  // TODO: Unlock Access
  return iRet;  
}

/*****************************************************************************/
/*! Writes to a file (non-reentrant)
*   \param iFile      File handle 
*   \param pvBuffer   Data to write to file
*   \param iBytes     number of bytes to write
*   \return number of bytes successfully written                             */
/*****************************************************************************/
_ssize_t write(int iFile, const void* pvBuffer, size_t iBytes)
{
  size_t         iWritten = 0;
  unsigned char* pbData   = (unsigned char*)pvBuffer;
   
  switch(iFile)
  {
  case STDERR_FILENO:
  case STDOUT_FILENO:
    iWritten = iBytes;
    while(iBytes-- > 0)
    {
      HAL_UartPutChar(0, *pbData++);
    }
    break;
        
  default:
    /*TODO: Implement for further files */
    break; 
  }
   
  return iWritten;  
}

/*****************************************************************************/
/*! Writes to a file (reentrant)
*   \param ptReent    Reentrancy structure 
*   \param iFile      File handle 
*   \param pvBuffer   Data to write to file
*   \param iBytes     number of bytes to write
*   \return number of bytes successfully written                             */
/*****************************************************************************/
_ssize_t _write_r(struct _reent* ptReent, int iFile, const void* pvBuffer, size_t iBytes)
{
  size_t iRet;
  // TODO: Lock Access
  
  iRet = write(iFile, pvBuffer, iBytes);
   
  // TODO: Unlock Access

  return iRet;
}

/*****************************************************************************/
/*! Writes to a file (non-reentrant)
*   \param iFile      File handle 
*   \param iOffset    Offset to adjust
*   \param iDirection Direction of iOffset (SEEK_SET, SEEK_CUR, SEEK_END)
*   \return new file offset                                                  */
/*****************************************************************************/
_off_t lseek(int iFile, _off_t iOffset, int iDirection)
{
  return 0;
}

/*****************************************************************************/
/*! Writes to a file (reentrant)
*   \param ptReent    Reentrancy structure 
*   \param iFile      File handle 
*   \param iOffset    Offset to adjust
*   \param iDirection Direction of iOffset (SEEK_SET, SEEK_CUR, SEEK_END)
*   \return new file offset                                                  */
/*****************************************************************************/
_off_t _lseek_r(struct _reent* ptReent, int iFile, _off_t iOffset, int iDirection)
{
  return 0;
}
